
/**
 * ajax requests handler
 *
 * object of options contains the url, data to send, headers
 */
const ajax = async (options) => {
    try {
        let data = options.data,
                method = options.method ? options.method : 'post',
                config = {
                    method: method,
                    url: options.url,
                    onUploadProgress: function (progressEvent) {

                    },
                    onDownloadProgress: function (progressEvent) {

                    }
                };
        if (options.dataType == 'json') {
            config.headers = {accept: 'application/json'};
        }

        if (options.method == 'get') {
            config.params = data;
        } else {
            config.data = data;
        }

        if (options.showLoading) {
            $('.butn').attr('disabled', 'disabled');
            $('.loading_page').css('display', 'block');
        }

        $('.loading_page').css('display', 'block');
        $('.butn').attr('disabled', 'disabled');
        // console.log('config',config)
        const response = await axios(config);
        if (options.showLoading) {
            $('.loading_page').css('display', 'none');
            $('.butn').removeAttr('disabled');
        }

        if (response.status == 200) {
            $('.loading_page').css('display', 'none');
            $('.butn').removeAttr('disabled');
            return response.data;
        }

        let message = response.data && response.data.message ? response.data.message : 'internetConnectionProblem';
        // alert(message)
        return false;
    } catch (err) {
        const {response: {data}} = err;

        if (data?.errors) {
            for (const [key, value] of Object.entries(data.errors)) {
                toasterError(value);
            }

        } else {
            toasterError(data.message || 'Request Error');
        }

        $('.loading_page').css('display', 'none');
        return false;
    }
};
// API
function toasterError(error) {
    // alert(error)
    toastr.options.closeButton = true;
    toastr.options.showMethod = 'slideDown';
    toastr.options.hideMethod = 'slideUp';
    toastr.options.closeMethod = 'slideUp';
    toastr.options.closeDuration = 200;
    toastr.error(error);
}
function toasterSuccess(success) {
    toastr.options.closeButton = true;
    toastr.options.showMethod = 'slideDown';
    toastr.options.hideMethod = 'slideUp';
    toastr.options.closeMethod = 'slideUp';
    toastr.options.closeDuration = 200;
    toastr.success(success);
}

$(document).ready(function () {

    /**
     * News Letter Module subscrubtion
     */

    $('.submit_butn').click(async function (e) {
        
        e.preventDefault();
        $('body').removeClass('loaded');
        let form = $('.news_form'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');
                // alert(url);
        const response = await ajax({
            url,
            data,
            dataType: 'json',
            method
        });
        if (response.errors) {
            $("#preloader").addClass("isdone");
            toasterError(response.errors);
        }
        if (response.message) {
            $("#preloader").addClass("isdone");
            toasterSuccess(response.message);
            $('.news_form .clearInput .form-control ').val('');

        }
    });

});
;